<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Vessel extends Model 
{

    protected $table = 'vessels';
    public $timestamps = true;
    protected $fillable = array('vessel_number', 'width', 'length', 'speed', 'image', 'max_weight', 'max_capacity', 'max_passengers', 'vessel_model_id', 'grouping');

    public function createdBy()
    {
        return $this->belongsTo('User', 'created_by');
    }

    public function vesselModel()
    {
        return $this->belongsTo('VesselModel', 'vessel_model');
    }

    public function lines()
    {
        return $this->hasMany('Lien', 'vessel_id');
    }

    public function vesselCabinsCounts()
    {
        return $this->hasMany('VesselCabinsCount', 'vessel_id');
    }

    public function trans()
    {
        return $this->hasMany('App\Models\VesselTrans');
    }

}